
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")


    # Set objective function
    m.setObjective(6*x0 + 7*x1 + 4*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(13*x0 + 3*x2 >= 30, "c0")
    m.addConstr(13*x0 + 9*x1 + 3*x2 >= 30, "c1")
    m.addConstr(4*x1 + 4*x2 >= 32, "c2")
    m.addConstr(14*x0 + 4*x1 + 4*x2 >= 32, "c3")
    m.addConstr(24*x0 + 21*x2 >= 28, "c4")
    m.addConstr(24*x0 + 10*x1 + 21*x2 >= 28, "c5")
    m.addConstr(3*x0 - 6*x1 >= 0, "c6")
    m.addConstr(-4*x0 + 6*x2 >= 0, "c7")
    m.addConstr(9*x1 + 3*x2 <= 136, "c8")
    m.addConstr(13*x0 + 9*x1 + 3*x2 <= 86, "c9")
    m.addConstr(4*x1 + 4*x2 <= 95, "c10")
    m.addConstr(14*x0 + 4*x1 <= 74, "c11")
    m.addConstr(10*x1 + 21*x2 <= 212, "c12")

    # Resource Constraints
    m.addConstr(13*x0 + 9*x1 + 3*x2 <= 147, "r0")
    m.addConstr(14*x0 + 4*x1 + 4*x2 <= 97, "r1")
    m.addConstr(24*x0 + 10*x1 + 21*x2 <= 244, "r2")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
