
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hamburgers = m.addVar(vtype=GRB.INTEGER, name="hamburgers")
bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")
black_beans = m.addVar(vtype=GRB.INTEGER, name="black_beans")
chicken_drumsticks = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")
tomatoes = m.addVar(vtype=GRB.CONTINUOUS, name="tomatoes")
cherry_pies = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")


# Set objective function
m.setObjective(1.99 * hamburgers + 6.45 * bowls_of_cereal + 3.61 * black_beans + 2.79 * chicken_drumsticks + 3.16 * tomatoes + 4.23 * cherry_pies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * hamburgers + 1 * bowls_of_cereal + 5 * black_beans + 5 * chicken_drumsticks + 5 * tomatoes + 2 * cherry_pies <= 129, "r0")
m.addConstr(4 * hamburgers + 8 * bowls_of_cereal + 2 * black_beans + 1 * chicken_drumsticks + 1 * tomatoes + 7 * cherry_pies <= 264, "r1")
m.addConstr(5 * black_beans + 5 * tomatoes >= 10)
m.addConstr(5 * chicken_drumsticks + 5 * tomatoes >= 15)
m.addConstr(4 * hamburgers + 5 * black_beans >= 13)
m.addConstr(1 * bowls_of_cereal + 5 * chicken_drumsticks >= 16)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks >= 28)
m.addConstr(4 * hamburgers + 7 * cherry_pies >= 19)
m.addConstr(2 * black_beans + 1 * tomatoes >= 35)
m.addConstr(4 * hamburgers + 1 * tomatoes >= 30)
m.addConstr(4 * hamburgers + 1 * chicken_drumsticks >= 17)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans >= 18)
m.addConstr(4 * hamburgers + 1 * tomatoes + 7 * cherry_pies >= 22)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 1 * tomatoes >= 22)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + 1 * tomatoes >= 22)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 7 * cherry_pies >= 22)
m.addConstr(4 * hamburgers + 1 * tomatoes + 7 * cherry_pies >= 37)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 1 * tomatoes >= 37)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + 1 * tomatoes >= 37)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 7 * cherry_pies >= 37)
m.addConstr(4 * hamburgers + 1 * tomatoes + 7 * cherry_pies >= 41)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 1 * tomatoes >= 41)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + 1 * tomatoes >= 41)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 7 * cherry_pies >= 41)
m.addConstr(4 * hamburgers + 1 * tomatoes + 7 * cherry_pies >= 35)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 1 * tomatoes >= 35)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + 1 * tomatoes >= 35)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 7 * cherry_pies >= 35)
m.addConstr(5 * tomatoes + 2 * cherry_pies <= 74)
m.addConstr(1 * bowls_of_cereal + 2 * cherry_pies <= 94)
m.addConstr(5 * black_beans + 5 * chicken_drumsticks + 2 * cherry_pies <= 62)
m.addConstr(5 * black_beans + 5 * tomatoes + 2 * cherry_pies <= 54)
m.addConstr(1 * bowls_of_cereal + 5 * chicken_drumsticks + 2 * cherry_pies <= 78)
m.addConstr(1 * bowls_of_cereal + 5 * black_beans + 5 * chicken_drumsticks <= 113)
m.addConstr(4 * hamburgers + 5 * black_beans + 5 * tomatoes <= 69)
m.addConstr(4 * hamburgers + 5 * black_beans + 2 * cherry_pies <= 24)
m.addConstr(4 * hamburgers + 1 * bowls_of_cereal + 5 * black_beans + 5 * chicken_drumsticks + 5 * tomatoes + 2 * cherry_pies <= 24)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks <= 244)
m.addConstr(4 * hamburgers + 1 * tomatoes <= 120)
m.addConstr(4 * hamburgers + 7 * cherry_pies <= 125)
m.addConstr(4 * hamburgers + 8 * bowls_of_cereal <= 155)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans <= 202)
m.addConstr(1 * tomatoes + 7 * cherry_pies <= 46)
m.addConstr(4 * hamburgers + 1 * tomatoes + 7 * cherry_pies <= 126)
m.addConstr(4 * hamburgers + 1 * chicken_drumsticks + 1 * tomatoes <= 207)
m.addConstr(4 * hamburgers + 8 * bowls_of_cereal + 2 * black_beans <= 82)
m.addConstr(4 * hamburgers + 2 * black_beans + 1 * tomatoes <= 225)
m.addConstr(4 * hamburgers + 5 * black_beans + 2 * cherry_pies <= 213)
m.addConstr(5 * black_beans + 5 * chicken_drumsticks + 2 * cherry_pies <= 245)
m.addConstr(8 * bowls_of_cereal + 1 * tomatoes + 7 * cherry_pies <= 242)
m.addConstr(4 * hamburgers + 1 * chicken_drumsticks + 7 * cherry_pies <= 117)
m.addConstr(8 * bowls_of_cereal + 1 * chicken_drumsticks + 7 * cherry_pies <= 61)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + 1 * tomatoes <= 143)
m.addConstr(2 * black_beans + tomatoes + 7 * cherry_pies <= 76)
m.addConstr(8 * bowls_of_cereal + chicken_drumsticks + tomatoes <= 224)
m.addConstr(8 * bowls_of_cereal + 2 * black_beans + chicken_drumsticks <= 190)
m.addConstr(4 * hamburgers + 8 * bowls_of_cereal + 2 * black_beans + chicken_drumsticks + tomatoes + 7 * cherry_pies <= 190)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
