
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="milligrams of iron")  # Iron
    x1 = m.addVar(name="milligrams of vitamin C")  # Vitamin C


    # Set objective function
    m.setObjective(3.43 * x0 + 5.11 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * x0 + 32 * x1 >= 73, "digestive_support_min")
    m.addConstr(1 * x0 + 2 * x1 >= 140, "cardiovascular_support_min")
    m.addConstr(22 * x0 + 16 * x1 >= 58, "kidney_support_min")
    m.addConstr(-2 * x0 + 7 * x1 >= 0, "constraint_4")
    m.addConstr(3 * x0 + 32 * x1 <= 147, "digestive_support_max")
    m.addConstr(1 * x0 + 2 * x1 <= 213, "cardiovascular_support_max")
    m.addConstr(22 * x0 + 16 * x1 <= 129, "kidney_support_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("milligrams of iron:", x0.x)
        print("milligrams of vitamin C:", x1.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if Gurobi is installed and licensed correctly.")

