
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="milligrams_of_iron", lb=0)  # Non-negative, can be fractional
x2 = m.addVar(name="milligrams_of_vitamin_C", lb=0)  # Non-negative, can be fractional

# Set the objective function
m.setObjective(3.43*x1 + 5.11*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 32*x2 >= 73, name="digestive_support_min")
m.addConstr(x1 + 2*x2 >= 140, name="cardiovascular_support_min")
m.addConstr(22*x1 + 16*x2 >= 58, name="kidney_support_min")
m.addConstr(-2*x1 + 7*x2 >= 0, name="linear_constraint")
m.addConstr(3*x1 + 32*x2 <= 147, name="digestive_support_max")
m.addConstr(x1 + 2*x2 <= 213, name="cardiovascular_support_max")
m.addConstr(22*x1 + 16*x2 <= 129, name="kidney_support_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x1.x}")
    print(f"Milligrams of vitamin C: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
