
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_iron", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=0)  # No lower bound specified, assuming 0

    # Objective function
    model.setObjective(3.43 * x1 + 5.11 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 32 * x2 >= 73, name="digestive_support_index_min")
    model.addConstr(1 * x1 + 2 * x2 >= 140, name="cardiovascular_support_index_min")
    model.addConstr(22 * x1 + 16 * x2 >= 58, name="kidney_support_index_min")
    model.addConstr(-2 * x1 + 7 * x2 >= 0, name="additional_constraint")
    model.addConstr(3 * x1 + 32 * x2 <= 147, name="digestive_support_index_max")
    model.addConstr(1 * x1 + 2 * x2 <= 213, name="cardiovascular_support_index_max")
    model.addConstr(22 * x1 + 16 * x2 <= 129, name="kidney_support_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
