
import gurobipy as gp

# Create a new model
model = gp.Model("nutrition_optimization")

# Create variables
vitamin_b6 = model.addVar(lb=0, name="vitamin_b6")
potassium = model.addVar(lb=0, name="potassium")
carbohydrates = model.addVar(lb=0, name="carbohydrates")
vitamin_b4 = model.addVar(lb=0, name="vitamin_b4")


# Set objective function
model.setObjective(8.98 * vitamin_b6 + 1.03 * potassium + 7.98 * carbohydrates + 3.6 * vitamin_b4, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * potassium + 2 * vitamin_b4 >= 12)
model.addConstr(5 * carbohydrates + 2 * vitamin_b4 >= 13)
model.addConstr(2 * vitamin_b6 + 5 * potassium + 2 * vitamin_b4 >= 10)
model.addConstr(2 * vitamin_b6 + 5 * carbohydrates + 2 * vitamin_b4 >= 10)
model.addConstr(2 * vitamin_b6 + 5 * potassium + 2 * vitamin_b4 >= 15)
model.addConstr(2 * vitamin_b6 + 5 * carbohydrates + 2 * vitamin_b4 >= 15)
model.addConstr(8 * vitamin_b6 + 5 * potassium + 5 * carbohydrates >= 14)
model.addConstr(8 * vitamin_b6 + 3 * potassium + 1 * carbohydrates >= 16)
model.addConstr(8 * vitamin_b6 + 1 * carbohydrates + 5 * vitamin_b4 >= 16)
model.addConstr(8 * vitamin_b6 + 3 * potassium + 1 * carbohydrates >= 12)
model.addConstr(8 * vitamin_b6 + 1 * carbohydrates + 5 * vitamin_b4 >= 12)
model.addConstr(2 * potassium + 2 * vitamin_b4 <= 52)
model.addConstr(2 * vitamin_b6 + 5 * potassium + 5 * carbohydrates + 2 * vitamin_b4 <= 77)
model.addConstr(8 * vitamin_b6 + 5 * potassium <= 37)
model.addConstr(8 * vitamin_b6 + 5 * carbohydrates <= 55)
model.addConstr(5 * potassium + 5 * carbohydrates <= 52)
model.addConstr(5 * potassium + 3 * vitamin_b4 <= 53)
model.addConstr(5 * potassium + 5 * carbohydrates + 3 * vitamin_b4 <= 64)
model.addConstr(8 * vitamin_b6 + 5 * potassium + 5 * carbohydrates + 3 * vitamin_b4 <= 64)
model.addConstr(3 * potassium + 1 * carbohydrates <= 64)
model.addConstr(1 * carbohydrates + 5 * vitamin_b4 <= 28)
model.addConstr(8 * vitamin_b6 + 1 * carbohydrates <= 56)
model.addConstr(3 * potassium + 5 * vitamin_b4 <= 74)
model.addConstr(8 * vitamin_b6 + 3 * potassium <= 53)
model.addConstr(8 * vitamin_b6 + 3 * potassium + 5 * vitamin_b4 <= 50)
model.addConstr(8 * vitamin_b6 + 3 * potassium + 1 * carbohydrates + 5 * vitamin_b4 <= 80)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin B6: {vitamin_b6.x}")
    print(f"Potassium: {potassium.x}")
    print(f"Carbohydrates: {carbohydrates.x}")
    print(f"Vitamin B4: {vitamin_b4.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

