
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")
    ravioli = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
    sashimi = m.addVar(vtype=gp.GRB.INTEGER, name="sashimi")

    # Set objective function
    m.setObjective(4.36 * milkshakes + 8.29 * ravioli + 5.64 * sashimi, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi <= 181, "fat_constraint")
    m.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 434, "carb_constraint")
    m.addConstr(6 * milkshakes + 9 * ravioli >= 20, "fat_milkshakes_ravioli")
    m.addConstr(9 * ravioli + 1 * sashimi >= 38, "fat_ravioli_sashimi")
    m.addConstr(6 * milkshakes + 1 * sashimi >= 24, "fat_milkshakes_sashimi")
    m.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi >= 50, "fat_total_min")
    m.addConstr(9 * milkshakes + 25 * sashimi >= 122, "carb_milkshakes_sashimi")
    m.addConstr(6 * milkshakes + 9 * ravioli <= 131, "fat_milkshakes_ravioli_max")
    m.addConstr(6 * milkshakes + 1 * sashimi <= 139, "fat_milkshakes_sashimi_max")
    m.addConstr(6 * milkshakes + 9 * ravioli + 1 * sashimi <= 139, "fat_total_max")
    m.addConstr(23 * ravioli + 25 * sashimi <= 286, "carb_ravioli_sashimi")
    m.addConstr(9 * milkshakes + 25 * sashimi <= 384, "carb_milkshakes_sashimi_max")
    m.addConstr(9 * milkshakes + 23 * ravioli <= 227, "carb_milkshakes_ravioli_max")
    m.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 227, "carb_total_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
