
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    milkshakes = model.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER)
    ravioli = model.addVar(name="ravioli", vtype=gurobi.GRB.INTEGER)
    sashimi = model.addVar(name="sashimi", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(4.36 * milkshakes + 8.29 * ravioli + 5.64 * sashimi, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * milkshakes + 9 * ravioli + sashimi <= 181)
    model.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 434)
    model.addConstr(6 * milkshakes + 9 * ravioli >= 20)
    model.addConstr(9 * ravioli + sashimi >= 38)
    model.addConstr(6 * milkshakes + sashimi >= 24)
    model.addConstr(6 * milkshakes + 9 * ravioli + sashimi >= 50)
    model.addConstr(9 * milkshakes + 25 * sashimi >= 122)
    model.addConstr(6 * milkshakes + 9 * ravioli <= 131)
    model.addConstr(6 * milkshakes + sashimi <= 139)
    model.addConstr(6 * milkshakes + 9 * ravioli + sashimi <= 139)
    model.addConstr(23 * ravioli + 25 * sashimi <= 286)
    model.addConstr(9 * milkshakes + 25 * sashimi <= 384)
    model.addConstr(9 * milkshakes + 23 * ravioli <= 227)
    model.addConstr(9 * milkshakes + 23 * ravioli + 25 * sashimi <= 227)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milkshakes: {milkshakes.varValue}")
        print(f"Ravioli: {ravioli.varValue}")
        print(f"Sashimi: {sashimi.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
