
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(8*x0 + 9*x1 + 4*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16*x1 + 5*x2 >= 51, "c0")
    model.addConstr(12*x0 + 5*x2 >= 24, "c1")
    model.addConstr(20*x0 + 12*x2 >= 34, "c2")
    model.addConstr(16*x1 + 12*x2 >= 96, "c3")
    model.addConstr(18*x0 + 2*x2 >= 42, "c4")
    model.addConstr(18*x0 + 11*x1 + 2*x2 >= 37, "c5")
    model.addConstr(16*x1 + 5*x2 <= 118, "c6")
    model.addConstr(12*x0 + 5*x2 <= 163, "c7")
    model.addConstr(12*x0 + 16*x1 + 5*x2 <= 125, "c8")
    model.addConstr(20*x0 + 12*x2 <= 194, "c9")
    model.addConstr(20*x0 + 16*x1 + 12*x2 <= 194, "c10")
    model.addConstr(11*x1 + 2*x2 <= 134, "c11")
    model.addConstr(18*x0 + 11*x1 <= 64, "c12")
    model.addConstr(18*x0 + 11*x1 + 2*x2 <= 64, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
