
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Bill
x1 = m.addVar(name="x1", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="x2", lb=0)  # hours worked by Jean

# Define the objective function
m.setObjective(8*x0 + 9*x1 + 4*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16*x1 + 5*x2 >= 51)
m.addConstr(12*x0 + 5*x2 >= 24)
m.addConstr(20*x0 + 12*x2 >= 34)
m.addConstr(16*x1 + 12*x2 >= 96)
m.addConstr(18*x0 + 2*x2 >= 42)
m.addConstr(18*x0 + 11*x1 + 2*x2 >= 37)
m.addConstr(16*x1 + 5*x2 <= 118)
m.addConstr(12*x0 + 5*x2 <= 163)
m.addConstr(12*x0 + 16*x1 + 5*x2 <= 125)
m.addConstr(20*x0 + 12*x2 <= 194)
m.addConstr(20*x0 + 16*x1 + 12*x2 <= 194)
m.addConstr(11*x1 + 2*x2 <= 134)
m.addConstr(18*x0 + 11*x1 <= 64)
m.addConstr(18*x0 + 11*x1 + 2*x2 <= 64)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bill: ", x0.varValue)
    print("Hours worked by Peggy: ", x1.varValue)
    print("Hours worked by Jean: ", x2.varValue)
else:
    print("The model is infeasible")
