
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy_hours")
george_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="george_hours")


# Set objective function
m.setObjective(2.56 * bill_hours + 7.44 * bobby_hours + 1.16 * peggy_hours + 8.8 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * peggy_hours + 15 * george_hours >= 12)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 17 * peggy_hours >= 14)
m.addConstr(13 * bobby_hours + 17 * peggy_hours + 15 * george_hours >= 14)
m.addConstr(14 * bill_hours + 17 * peggy_hours + 15 * george_hours >= 14)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 15 * george_hours >= 14)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 17 * peggy_hours >= 18)
m.addConstr(13 * bobby_hours + 17 * peggy_hours + 15 * george_hours >= 18)
m.addConstr(14 * bill_hours + 17 * peggy_hours + 15 * george_hours >= 18)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 15 * george_hours >= 18)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 17 * peggy_hours >= 11)
m.addConstr(13 * bobby_hours + 17 * peggy_hours + 15 * george_hours >= 11)
m.addConstr(14 * bill_hours + 17 * peggy_hours + 15 * george_hours >= 11)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 15 * george_hours >= 11)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 17 * peggy_hours >= 19)
m.addConstr(13 * bobby_hours + 17 * peggy_hours + 15 * george_hours >= 19)
m.addConstr(14 * bill_hours + 17 * peggy_hours + 15 * george_hours >= 19)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 15 * george_hours >= 19)
m.addConstr(14 * bill_hours + 13 * bobby_hours + 17 * peggy_hours + 15 * george_hours >= 19)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

