
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    iron = m.addVar(lb=0, name="iron")  # milligrams of iron
    b9 = m.addVar(lb=0, name="b9")  # milligrams of vitamin B9

    # Set objective function
    m.setObjective(6.68 * iron + 7.55 * b9, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.4 * iron + 0.14 * b9 >= 47, "cardiovascular_support_min")
    m.addConstr(0.4 * iron + 0.14 * b9 <= 104, "cardiovascular_support_max")
    m.addConstr(-3 * iron + 4 * b9 >= 0, "iron_b9_ratio")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of iron: {iron.x}")
        print(f"  Milligrams of vitamin B9: {b9.x}")
        print(f"  Objective value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
