
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_iron")
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B9")

# Define the objective function
m.setObjective(6.68*x1 + 7.55*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.4*x1 + 0.14*x2 >= 47, "cardiovascular_support_index_min")
m.addConstr(-3*x1 + 4*x2 >= 0, "iron_vitamin_b9_ratio")
m.addConstr(0.4*x1 + 0.14*x2 <= 104, "cardiovascular_support_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x1.x}")
    print(f"Milligrams of vitamin B9: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
