
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_iron", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milligrams_of_vitamin_B9", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(6.68 * x1 + 7.55 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.4 * x1 == 0.4, name="cardiovascular_support_index_iron")
    model.addConstr(0.14 * x2 == 0.14, name="cardiovascular_support_index_vitamin_B9")
    model.addConstr(0.4 * x1 + 0.14 * x2 >= 47, name="combined_cardiovascular_support_index_min")
    model.addConstr(-3 * x1 + 4 * x2 >= 0, name="iron_vitamin_B9_constraint")
    model.addConstr(0.4 * x1 + 0.14 * x2 <= 104, name="combined_cardiovascular_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of vitamin B9: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
