
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
rotisserie_chickens = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
instant_ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="instant_ramen")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")

# Set objective function
m.setObjective(3.79 * bananas + 6.29 * rotisserie_chickens + 3.04 * instant_ramen + 4.52 * apples, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * bananas + 10 * apples >= 120)
m.addConstr(14 * rotisserie_chickens + 22 * apples >= 63)
m.addConstr(4 * bananas + 14 * rotisserie_chickens >= 47)
m.addConstr(14 * rotisserie_chickens + 9 * instant_ramen >= 50)
m.addConstr(6 * bananas + 16 * apples <= 265)
m.addConstr(20 * rotisserie_chickens + 16 * apples <= 291)
m.addConstr(6 * bananas + 20 * rotisserie_chickens + 23 * instant_ramen + 16 * apples <= 291)
m.addConstr(7 * bananas + 10 * apples <= 462)
m.addConstr(5 * rotisserie_chickens + 11 * instant_ramen <= 130)
m.addConstr(5 * rotisserie_chickens + 10 * apples <= 199)
m.addConstr(7 * bananas + 5 * rotisserie_chickens <= 463)
m.addConstr(7 * bananas + 5 * rotisserie_chickens + 11 * instant_ramen + 10 * apples <= 463)
m.addConstr(14 * rotisserie_chickens + 22 * apples <= 430)
m.addConstr(4 * bananas + 9 * instant_ramen <= 213)
m.addConstr(4 * bananas + 14 * rotisserie_chickens + 9 * instant_ramen + 22 * apples <= 213)
m.addConstr(21 * bananas + 21 * apples <= 74)
m.addConstr(21 * bananas + 16 * rotisserie_chickens <= 132)
m.addConstr(16 * rotisserie_chickens + 21 * apples <= 90)
m.addConstr(21 * bananas + 21 * instant_ramen <= 99)
m.addConstr(16 * rotisserie_chickens + 21 * instant_ramen + 21 * apples <= 113)
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * apples <= 177)
m.addConstr(21 * bananas + 16 * rotisserie_chickens + 21 * instant_ramen + 21 * apples <= 177)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

