
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="bananas", lb=-float('inf'), ub=float('inf'))
    x1 = model.addVar(name="rotisserie chickens", lb=-float('inf'), ub=float('inf'))
    x2 = model.addVar(name="bowls of instant ramen", lb=-float('inf'), ub=float('inf'))
    x3 = model.addVar(name="apples", lb=-float('inf'), ub=float('inf'))

    # Define the objective function
    model.setObjective(3.79*x0 + 6.29*x1 + 3.04*x2 + 4.52*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*x0 + 10*x3 >= 120)
    model.addConstr(14*x1 + 22*x3 >= 63)
    model.addConstr(4*x0 + 14*x1 >= 47)
    model.addConstr(14*x1 + 9*x2 >= 50)
    model.addConstr(6*x0 + 16*x3 <= 265)
    model.addConstr(20*x1 + 16*x3 <= 291)
    model.addConstr(6*x0 + 20*x1 + 23*x2 + 16*x3 <= 291)
    model.addConstr(7*x0 + 10*x3 <= 462)
    model.addConstr(5*x1 + 11*x2 <= 130)
    model.addConstr(5*x1 + 10*x3 <= 199)
    model.addConstr(7*x0 + 5*x1 <= 463)
    model.addConstr(7*x0 + 5*x1 + 11*x2 + 10*x3 <= 463)
    model.addConstr(14*x1 + 22*x3 <= 430)
    model.addConstr(4*x0 + 9*x2 <= 213)
    model.addConstr(4*x0 + 14*x1 + 9*x2 + 22*x3 <= 213)
    model.addConstr(21*x0 + 21*x3 <= 74)
    model.addConstr(21*x0 + 16*x1 <= 132)
    model.addConstr(16*x1 + 21*x3 <= 90)
    model.addConstr(21*x0 + 21*x2 <= 99)
    model.addConstr(16*x1 + 21*x2 + 21*x3 <= 113)
    model.addConstr(21*x0 + 16*x1 + 21*x3 <= 177)
    model.addConstr(21*x0 + 16*x1 + 21*x2 + 21*x3 <= 177)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print("Objective value:", model.objVal)
        print("bananas:", x0.varValue)
        print("rotisserie chickens:", x1.varValue)
        print("bowls of instant ramen:", x2.varValue)
        print("apples:", x3.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
