
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x = {}
variables = ['packs of napkins', 'lightbulbs', 'cookies', 'paper towel rolls', 'cartons of milk']
for i in range(len(variables)):
    x[i] = model.addVar(vtype=gp.GRB.INTEGER, name=variables[i])


# Set objective function
objective = 4*x[0]**2 + 7*x[0]*x[1] + 2*x[0]*x[2] + 4*x[0]*x[3] + 6*x[0]*x[4] + 3*x[1]**2 + 7*x[1]*x[2] + 9*x[1]*x[3] + 5*x[1]*x[4] + x[2]**2 + 7*x[2]*x[3] + 5*x[3]**2 + 9*x[3]*x[4] + 6*x[4]**2 + 2*x[0] + 2*x[1] + 7*x[2] + 9*x[3] + 2*x[4]
model.setObjective(objective, gp.GRB.MINIMIZE)

# Add constraints
resources = {'r0': {'description': 'storage space', 'upper_bound': 121, 'x0': 9, 'x1': 3, 'x2': 11, 'x3': 4, 'x4': 8}, 'r1': {'description': 'weight', 'upper_bound': 154, 'x0': 11, 'x1': 11, 'x2': 2, 'x3': 14, 'x4': 2}}
model.addConstr(9*x[0] + 3*x[1] + 11*x[2] + 4*x[3] + 8*x[4] <= resources['r0']['upper_bound'], "storage_space")
model.addConstr(11*x[0] + 11*x[1] + 2*x[2] + 14*x[3] + 2*x[4] <= resources['r1']['upper_bound'], "weight")


model.addConstr(4*x[3] + 8*x[4] >= 13)
model.addConstr(9*x[0] + 11*x[2] >= 21)
model.addConstr(9*x[0] + 3*x[1] >= 23)
model.addConstr(3*x[1] + 4*x[3] >= 11)
model.addConstr(3*x[1]**2 + 8*x[4]**2 >= 23)
model.addConstr(9*x[0] + 4*x[3] >= 15)
model.addConstr(9*x[0] + 3*x[1] + 4*x[3] >= 12)
model.addConstr(9*x[0] + 3*x[1] + 11*x[2] + 4*x[3] + 8*x[4] >= 12)
model.addConstr(11*x[0]**2 + 11*x[1]**2 >= 30)
model.addConstr(11*x[0]**2 + 2*x[4]**2 >= 14)
model.addConstr(11*x[0]**2 + 2*x[2]**2 >= 16)
model.addConstr(11*x[1] + 2*x[4] >= 16)
model.addConstr(11*x[1] + 14*x[3] >= 23)
model.addConstr(2*x[2] + 2*x[4] >= 27)
model.addConstr(2*x[2]**2 + 14*x[3]**2 >= 11)
model.addConstr(11*x[0] + 14*x[3] >= 23)
model.addConstr(11*x[0]**2 + 11*x[1]**2 + 2*x[4]**2 >= 27)
model.addConstr(2*x[2] + 14*x[3] + 2*x[4] >= 27)
model.addConstr(11*x[0] + 11*x[1] + 2*x[4] >= 22)
model.addConstr(2*x[2] + 14*x[3] + 2*x[4] >= 22)
model.addConstr(11*x[0] + 11*x[1] + 2*x[2] + 14*x[3] + 2*x[4] >= 22)
model.addConstr(-x[1] + 4*x[4] >= 0)
model.addConstr(-8*x[2] + 8*x[4] >= 0)
model.addConstr(3*x[1] + 11*x[2] <= 121)
model.addConstr(9*x[0]**2 + 11*x[2]**2 <= 37)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Obj: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

