
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name='x0', vtype=gurobi.GRB.INTEGER) # packs of napkins
x1 = model.addVar(name='x1', vtype=gurobi.GRB.INTEGER) # lightbulbs
x2 = model.addVar(name='x2', vtype=gurobi.GRB.INTEGER) # cookies
x3 = model.addVar(name='x3', vtype=gurobi.GRB.INTEGER) # paper towel rolls
x4 = model.addVar(name='x4', vtype=gurobi.GRB.INTEGER) # cartons of milk

# Objective function
model.setObjective(4*x0**2 + 7*x0*x1 + 2*x0*x2 + 4*x0*x3 + 6*x0*x4 + 
                   3*x1**2 + 7*x1*x2 + 9*x1*x3 + 5*x1*x4 + x2**2 + 
                   7*x2*x3 + 5*x3**2 + 9*x3*x4 + 6*x4**2 + 2*x0 + 
                   2*x1 + 7*x2 + 9*x3 + 2*x4, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(9*x0 <= 121)
model.addConstr(11*x0 <= 154)
model.addConstr(3*x1 <= 121)
model.addConstr(11*x1 <= 154)
model.addConstr(11*x2 <= 121)
model.addConstr(2*x2 <= 154)
model.addConstr(4*x3 <= 121)
model.addConstr(14*x3 <= 154)
model.addConstr(8*x4 <= 121)
model.addConstr(2*x4 <= 154)

model.addConstr(4*x3 + 8*x4 >= 13)
model.addConstr(9*x0 + 11*x2 >= 21)
model.addConstr(9*x0 + 3*x1 >= 23)
model.addConstr(3*x1 + 4*x3 >= 11)
model.addConstr(3*x1**2 + 2*x4**2 >= 23)
model.addConstr(9*x0 + 4*x3 >= 15)
model.addConstr(9*x0 + 3*x1 + 4*x3 >= 12)
model.addConstr(9*x0 + 3*x1 + 11*x2 + 4*x3 + 8*x4 >= 12)

model.addConstr(11*x0**2 + 11*x1**2 >= 30)
model.addConstr(11*x0**2 + 2*x4**2 >= 14)
model.addConstr(11*x0**2 + 2*x2**2 >= 16)
model.addConstr(11*x1 + 2*x4 >= 16)
model.addConstr(11*x1 + 14*x3 >= 23)
model.addConstr(2*x2 + 2*x4 >= 27)
model.addConstr(2*x2**2 + 5*x3**2 >= 11)
model.addConstr(11*x0 + 14*x3 >= 23)
model.addConstr(11*x0**2 + 11*x1**2 + 2*x4**2 >= 27)
model.addConstr(2*x2 + 14*x3 + 2*x4 >= 27)
model.addConstr(11*x0 + 11*x1 + 2*x4 >= 22)
model.addConstr(2*x2 + 14*x3 + 2*x4 >= 22)
model.addConstr(11*x0 + 11*x1 + 2*x2 + 14*x3 + 2*x4 >= 22)

model.addConstr(-x1 + 4*x4 >= 0)
model.addConstr(-8*x2 + 8*x4 >= 0)
model.addConstr(3*x1 + 11*x2 <= 121)
model.addConstr(9*x0**2 + 11*x2**2 <= 37)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('No solution found')
