
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="manila_envelopes")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="red_highlighters")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="paper_clips")


    # Set objective function
    m.setObjective(9*x0 + 8*x1 + x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9.78*x0 + 12.61*x2 >= 40, "c1")
    m.addConstr(9.78*x0 + 4.69*x1 >= 62, "c2")
    m.addConstr(9.78*x0 + 4.69*x1 + 12.61*x2 >= 62, "c3")
    m.addConstr(2*x0 - 7*x1 >= 0, "c4")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('manila_envelopes:', x0.x)
        print('red_highlighters:', x1.x)
        print('paper_clips:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

