
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="manila_envelopes")
x2 = m.addVar(vtype=GRB.INTEGER, name="red_highlighters")
x3 = m.addVar(vtype=GRB.INTEGER, name="paper_clips")

# Set objective function
m.setObjective(9*x1 + 8*x2 + x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(9.78*x1 + 12.61*x3 >= 40, "sustainability_score_min_1")
m.addConstr(9.78*x1 + 4.69*x2 >= 62, "sustainability_score_min_2")
m.addConstr(9.78*x1 + 4.69*x2 + 12.61*x3 >= 62, "total_sustainability_score_min")
m.addConstr(2*x1 - 7*x2 >= 0, "envelopes_highlighters_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Manila Envelopes:", x1.x)
    print("Red Highlighters:", x2.x)
    print("Paper Clips:", x3.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found")
