
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='manila_envelopes', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='red_highlighters', vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name='paper_clips', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9 * x1 + 8 * x2 + x3, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(9.78 * x1 + 12.61 * x3 >= 40)
    model.addConstr(9.78 * x1 + 4.69 * x2 >= 62)
    model.addConstr(9.78 * x1 + 4.69 * x2 + 12.61 * x3 >= 62)
    model.addConstr(2 * x1 - 7 * x2 >= 0)

    # Set the sustainability score upper bound (not directly mentioned as a constraint but as an attribute)
    # This is not a constraint but an attribute, so we don't add it directly to the model

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Manila envelopes: {x1.varValue}")
        print(f"Red highlighters: {x2.varValue}")
        print(f"Paper clips: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
