
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B3")
    x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_B2")


    # Set objective function
    m.setObjective(6*x0 + 3*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.06*x0 + 0.26*x2 >= 11, "c0")
    m.addConstr(0.06*x0 + 8.56*x1 + 0.26*x2 >= 15, "c1")
    m.addConstr(1.05*x0 + 7.92*x1 >= 11, "c2")
    m.addConstr(1.05*x0 + 7.92*x1 + 4.16*x2 >= 12, "c3")
    m.addConstr(8.57*x0 + 7.38*x1 >= 25, "c4")
    m.addConstr(8.57*x0 + 7.38*x1 + 6.67*x2 >= 25, "c5")
    m.addConstr(2*x0 - 9*x2 >= 0, "c6")
    m.addConstr(8.56*x1 + 0.26*x2 <= 43, "c7")
    m.addConstr(0.06*x0 + 0.26*x2 <= 19, "c8")
    m.addConstr(1.05*x0 + 7.92*x1 + 4.16*x2 <= 58, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B5: %g' % x0.x)
        print('Vitamin B3: %g' % x1.x)
        print('Vitamin B2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
