
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # milligrams of vitamin B5
x1 = m.addVar(name="x1", lb=0, integrality=1)  # milligrams of vitamin B3
x2 = m.addVar(name="x2", lb=0, integrality=1)  # milligrams of vitamin B2

# Objective function
m.setObjective(6 * x0 + 3 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(0.06 * x0 <= 50)
m.addConstr(1.05 * x0 <= 66)
m.addConstr(8.57 * x0 <= 126)
m.addConstr(8.56 * x1 <= 50)
m.addConstr(7.92 * x1 <= 66)
m.addConstr(7.38 * x1 <= 126)
m.addConstr(0.26 * x2 <= 50)
m.addConstr(4.16 * x2 <= 66)
m.addConstr(6.67 * x2 <= 126)
m.addConstr(0.06 * x0 + 0.26 * x2 >= 11)
m.addConstr(0.06 * x0 + 8.56 * x1 + 0.26 * x2 >= 15)
m.addConstr(1.05 * x0 + 7.92 * x1 >= 11)
m.addConstr(1.05 * x0 + 7.92 * x1 + 4.16 * x2 >= 12)
m.addConstr(8.57 * x0 + 7.38 * x1 >= 25)
m.addConstr(8.57 * x0 + 7.38 * x1 + 6.67 * x2 >= 25)
m.addConstr(2 * x0 - 9 * x2 >= 0)
m.addConstr(8.56 * x1 + 0.26 * x2 <= 43)
m.addConstr(0.06 * x0 + 0.26 * x2 <= 19)
m.addConstr(1.05 * x0 + 7.92 * x1 + 4.16 * x2 <= 58)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x0 (milligrams of vitamin B5): {x0.varValue}")
    print(f"x1 (milligrams of vitamin B3): {x1.varValue}")
    print(f"x2 (milligrams of vitamin B2): {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
