
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(7, lb=0, vtype=gp.GRB.CONTINUOUS, name=["x0", "x1", "x2", "x3", "x4", "x5", "x6"])


# Set objective function
m.setObjective(6.28 * x[0] + 1.27 * x[1] + 2.83 * x[2] + 2.3 * x[3] + 4.99 * x[4] + 7.51 * x[5] + 8.69 * x[6], gp.GRB.MINIMIZE)

# Add constraints based on the JSON output

digestive_support_coefficients = [9, 5, 18, 4, 4, 1, 14]
energy_stability_coefficients = [11, 3, 12, 20, 20, 18, 3]

m.addConstr(sum(digestive_support_coefficients[i] * x[i] for i in range(7)) <= 213, "r0")
m.addConstr(sum(energy_stability_coefficients[i] * x[i] for i in range(7)) <= 332, "r1")


constraints_data = {  # index : [variables, rhs, sense]
    0: [[0, 6], 18, gp.GRB.GREATER_EQUAL],
    1: [[1, 5], 23, gp.GRB.GREATER_EQUAL],
    2: [[1, 4], 13, gp.GRB.GREATER_EQUAL],
    3: [[2, 3], 20, gp.GRB.GREATER_EQUAL],
    4: [[4, 5], 21, gp.GRB.GREATER_EQUAL],
    5: [[0, 4], 16, gp.GRB.GREATER_EQUAL],
    6: [[1, 3], 27, gp.GRB.GREATER_EQUAL],
    7: [[5, 6], 28, gp.GRB.GREATER_EQUAL],
    8: [[3, 5], 23, gp.GRB.GREATER_EQUAL],
    9: [[0, 2], 19, gp.GRB.GREATER_EQUAL],
    10: [[1, 6], 19, gp.GRB.GREATER_EQUAL],
    11: [[2, 3, 5], 16, gp.GRB.GREATER_EQUAL],
    12: [[1, 4, 5], 16, gp.GRB.GREATER_EQUAL],
    13: [[0, 3, 5], 16, gp.GRB.GREATER_EQUAL],
    14: [[0, 5, 6], 16, gp.GRB.GREATER_EQUAL],
    15: [[1, 3, 5], 16, gp.GRB.GREATER_EQUAL],
    16: [[0, 1, 6], 16, gp.GRB.GREATER_EQUAL],
    17: [[3, 4, 5], 16, gp.GRB.GREATER_EQUAL],
    18: [[2, 5, 6], 16, gp.GRB.GREATER_EQUAL],
    19: [[0, 2, 3], 16, gp.GRB.GREATER_EQUAL],
    20: [[0, 1, 2], 16, gp.GRB.GREATER_EQUAL],
    21: [[0, 1, 3], 16, gp.GRB.GREATER_EQUAL],
    22: [[0, 1, 2, 3, 4, 5, 6], 15, gp.GRB.GREATER_EQUAL],
    23: [[2, 4], 15, gp.GRB.GREATER_EQUAL],
    24: [[1, 4], 34, gp.GRB.GREATER_EQUAL],
    25: [[0, 2, 4], 27, gp.GRB.GREATER_EQUAL],
    26: [[0, 1, 2, 3, 4, 5, 6], 27, gp.GRB.GREATER_EQUAL],
    27: [[0, 6], 0, gp.GRB.GREATER_EQUAL, [-7, 3]],
    28: [[3, 5], 0, gp.GRB.GREATER_EQUAL, [-7, 8]],
    29: [[2, 5], 113, gp.GRB.LESS_EQUAL],
    30: [[2, 4], 115, gp.GRB.LESS_EQUAL],
    31: [[1, 5], 64, gp.GRB.LESS_EQUAL],
    32: [[4, 6], 173, gp.GRB.LESS_EQUAL],
    33: [[1, 3], 190, gp.GRB.LESS_EQUAL],
    34: [[1, 4], 186, gp.GRB.LESS_EQUAL],
    35: [[2, 6], 173, gp.GRB.LESS_EQUAL],
    36: [[4, 5], 33, gp.GRB.LESS_EQUAL],
    37: [[1, 6], 73, gp.GRB.LESS_EQUAL],
    38: [[3, 5], 59, gp.GRB.LESS_EQUAL],
    39: [[5, 6], 196, gp.GRB.LESS_EQUAL],
    40: [[0, 3, 5], 181, gp.GRB.LESS_EQUAL],
    41: [[3, 4, 6], 205, gp.GRB.LESS_EQUAL],
    42: [[2, 4, 6], 100, gp.GRB.LESS_EQUAL],
    43: [[2, 4], 75, gp.GRB.LESS_EQUAL, [12, 20]],
    44: [[1, 4], 34, gp.GRB.GREATER_EQUAL, [3, 20]],
    45: [[1, 2], 61, gp.GRB.LESS_EQUAL, [3, 12]],
    46: [[1, 3], 246, gp.GRB.LESS_EQUAL, [3, 20]],
    47: [[4, 5], 56, gp.GRB.LESS_EQUAL, [20, 18]],
    48: [[1, 2, 6], 332, gp.GRB.LESS_EQUAL, [3, 12, 3]],
    49: [[1, 3, 5], 106, gp.GRB.LESS_EQUAL, [3, 20, 18]],
    50: [[1, 4, 6], 123, gp.GRB.LESS_EQUAL, [3, 20, 3]],
    51: [[0, 1, 6], 244, gp.GRB.LESS_EQUAL, [11, 3, 3]],
    52: [[3, 4, 6], 130, gp.GRB.LESS_EQUAL, [20, 20, 3]],
    53: [[2, 3, 6], 215, gp.GRB.LESS_EQUAL, [12, 20, 3]],
    54: [[0, 1, 2], 180, gp.GRB.LESS_EQUAL, [11, 3, 12]],
    55: [[0, 2, 5], 56, gp.GRB.LESS_EQUAL, [11, 12, 18]],
    56: [[0, 1, 4], 249, gp.GRB.LESS_EQUAL, [11, 3, 20]],
    57: [[1, 4, 5], 100, gp.GRB.LESS_EQUAL, [3, 20, 18]],
    58: [[1, 3, 6], 252, gp.GRB.LESS_EQUAL, [3, 20, 3]],
    59: [[0, 3, 4], 207, gp.GRB.LESS_EQUAL, [11, 20, 20]],
    60: [[2, 5, 6], 113, gp.GRB.LESS_EQUAL, [12, 18, 3]],
    61: [[0, 5, 6], 172, gp.GRB.LESS_EQUAL, [11, 18, 3]],
    62: [[2, 4, 5], 247, gp.GRB.LESS_EQUAL, [12, 20, 18]],
    63: [[1, 3, 4], 175, gp.GRB.LESS_EQUAL, [3, 20, 20]],
    64: [[0, 1, 3], 51, gp.GRB.LESS_EQUAL, [11, 3, 20]],
    65: [[2, 3, 5], 178, gp.GRB.LESS_EQUAL, [12, 20, 18]]
}

for i, data in constraints_data.items():
    variables = data[0]
    rhs = data[1]
    sense = data[2]
    if len(data) > 3:
        coefficients = data[3]
        m.addConstr(sum(coefficients[j] * x[variables[j]] for j in range(len(variables))) * 1.0 >= rhs, f"c{i}")
    else:
        m.addConstr(sum(digestive_support_coefficients[j] * x[j] for j in variables) * 1.0 >= rhs if sense == gp.GRB.GREATER_EQUAL else sum(
            digestive_support_coefficients[j] * x[j] for j in variables) * 1.0 <= rhs, f"c{i}")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

