
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")
peggy = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
george = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")
mary = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")


# Set objective function
m.setObjective(6.0*jean**2 + 6.79*jean*peggy + 7.63*jean*george + 5.35*jean*mary + 3.06*peggy**2 + 2.94*peggy*george + 3.06*peggy*mary + 8.23*george**2 + 8.03*george*mary + 4.6*mary**2 + 5.47*jean + 6.14*peggy + 1.27*george + 8.79*mary, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.15*peggy**2 + 0.69*mary**2 >= 59)
m.addConstr(0.15*peggy + 0.24*george >= 67)
m.addConstr(0.11*jean + 0.69*mary >= 34)
m.addConstr(0.11*jean**2 + 0.24*george**2 >= 45)
m.addConstr(0.24*george**2 + 0.69*mary**2 >= 38)
m.addConstr(0.11*jean + 0.15*peggy + 0.69*mary >= 63)
m.addConstr(0.15*peggy + 0.24*george + 0.69*mary >= 63)
m.addConstr(0.11*jean + 0.24*george + 0.69*mary >= 63)
m.addConstr(0.11*jean**2 + 0.15*peggy**2 + 0.24*george**2 >= 63)
m.addConstr(0.11*jean**2 + 0.15*peggy**2 + 0.69*mary**2 >= 47)
m.addConstr(0.15*peggy + 0.24*george + 0.69*mary >= 47)
m.addConstr(0.11*jean + 0.24*george + 0.69*mary >= 47)
m.addConstr(0.11*jean**2 + 0.15*peggy**2 + 0.24*george**2 >= 47)
m.addConstr(0.11*jean + 0.15*peggy + 0.69*mary >= 38)
m.addConstr(0.15*peggy + 0.24*george + 0.69*mary >= 38)
m.addConstr(0.11*jean + 0.24*george + 0.69*mary >= 38)
m.addConstr(0.11*jean**2 + 0.15*peggy**2 + 0.24*george**2 >= 38)
m.addConstr(0.11*jean + 0.15*peggy + 0.69*mary >= 43)
m.addConstr(0.15*peggy + 0.24*george + 0.69*mary >= 43)
m.addConstr(0.11*jean + 0.24*george + 0.69*mary >= 43)
m.addConstr(0.11*jean**2 + 0.15*peggy**2 + 0.24*george**2 >= 43)
m.addConstr(0.11*jean + 0.15*peggy + 0.24*george + 0.69*mary >= 43)
m.addConstr(0.25*jean**2 + 0.79*peggy**2 >= 36)
m.addConstr(0.25*jean**2 + 0.79*peggy**2 + 0.72*george**2 >= 59)
m.addConstr(0.25*jean + 0.79*peggy + 0.72*george + 0.27*mary >= 59)
m.addConstr(0.26*george + 0.25*mary >= 67)
m.addConstr(0.85*jean**2 + 0.25*mary**2 >= 74)
m.addConstr(0.85*jean + 0.07*peggy >= 76)
m.addConstr(0.85*jean + 0.26*george >= 71)
m.addConstr(0.07*peggy + 0.26*george >= 44)
m.addConstr(0.07*peggy + 0.26*george + 0.25*mary >= 75)
m.addConstr(0.85*jean + 0.07*peggy + 0.26*george >= 75)
m.addConstr(0.07*peggy + 0.26*george + 0.25*mary >= 76)
m.addConstr(0.85*jean**2 + 0.07*peggy**2 + 0.26*george**2 >= 76)
m.addConstr(0.85*jean + 0.07*peggy + 0.26*george + 0.25*mary >= 76)
m.addConstr(0.69*jean + 0.18*mary >= 24)
m.addConstr(0.6*george**2 + 0.18*mary**2 >= 20)
m.addConstr(0.69*jean + 0.6*george >= 45)
m.addConstr(0.03*peggy**2 + 0.18*mary**2 >= 21)
m.addConstr(0.69*jean + 0.03*peggy >= 25)
m.addConstr(0.69*jean + 0.03*peggy + 0.6*george >= 41)
m.addConstr(0.69*jean + 0.6*george + 0.18*mary >= 41)
m.addConstr(0.03*peggy**2 + 0.6*george**2 + 0.18*mary**2 >= 41)
m.addConstr(0.69*jean + 0.03*peggy + 0.6*george >= 41)
m.addConstr(0.69*jean**2 + 0.6*george**2 + 0.18*mary**2 >= 41)
m.addConstr(0.03*peggy**2 + 0.6*george**2 + 0.18*mary**2 >= 41)
m.addConstr(0.69*jean**2 + 0.03*peggy**2 + 0.6*george**2 >= 47)
m.addConstr(0.69*jean**2 + 0.6*george**2 + 0.18*mary**2 >= 47)
m.addConstr(0.03*peggy**2 + 0.6*george**2 + 0.18*mary**2 >= 47)
m.addConstr(0.69*jean + 0.03*peggy + 0.6*george + 0.18*mary >= 47)
m.addConstr(9*peggy - 8*mary >= 0)
m.addConstr(-8*george + 3*mary >= 0)
m.addConstr(0.79*peggy**2 + 0.27*mary**2 <= 162)
m.addConstr(0.25*jean + 0.79*peggy + 0.27*mary <= 106)
m.addConstr(0.85*jean + 0.07*peggy + 0.25*mary <= 169)
m.addConstr(0.85*jean**2 + 0.07*peggy**2 + 0.26*george**2 <= 308)
m.addConstr(0.07*peggy + 0.26*george + 0.25*mary <= 208)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

