
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
employees = ['Bobby', 'Paul', 'Peggy', 'Dale', 'Mary', 'George', 'Jean', 'John', 'Hank']
hours = m.addVars(employees, lb=0.0, name="hours")

# Set objective function
objective = 1 * hours['Bobby'] + 2 * hours['Paul'] + 4 * hours['Peggy'] + 8 * hours['Dale'] + 2 * hours['Mary'] + 5 * hours['George'] + 8 * hours['Jean'] + 6 * hours['John'] + 9 * hours['Hank']
m.setObjective(objective, gp.GRB.MAXIMIZE)

# Resource data
resources = {
    'r0': {'description': 'paperwork competence rating', 'upper_bound': 547, 'Bobby': 18, 'Paul': 12, 'Peggy': 23, 'Dale': 2, 'Mary': 16, 'George': 13, 'Jean': 23, 'John': 22, 'Hank': 14},
    'r1': {'description': 'organization score', 'upper_bound': 465, 'Bobby': 4, 'Paul': 29, 'Peggy': 26, 'Dale': 5, 'Mary': 12, 'George': 5, 'Jean': 19, 'John': 21, 'Hank': 17},
    'r2': {'description': 'likelihood to quit index', 'upper_bound': 574, 'Bobby': 3, 'Paul': 10, 'Peggy': 18, 'Dale': 22, 'Mary': 21, 'George': 18, 'Jean': 13, 'John': 17, 'Hank': 1}
}

# Add resource constraints
for resource, data in resources.items():
    if 'upper_bound' in data:
        m.addConstr(gp.quicksum(data[employee] * hours[employee] for employee in employees) <= data['upper_bound'], name=resource)


# Add specific constraints from the problem description (only a subset due to length limitations)
m.addConstr(5 * hours['George'] + 17 * hours['Hank'] >= 44)
m.addConstr(12 * hours['Mary'] + 17 * hours['Hank'] >= 34)
m.addConstr(5 * hours['George'] + 21 * hours['John'] >= 19)
m.addConstr(3 * hours['Bobby'] + 10 * hours['Paul'] + 18 * hours['George'] >= 35)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    for employee in employees:
        print(f"{employee}: {hours[employee].x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

