
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Add variables
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
x3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Set the objective function
model.setObjective(8.72*x1 + 5.55*x2 + 1.19*x3, GRB.MINIMIZE)

# Add constraints
model.addConstr(9.26*x1 <= 108)
model.addConstr(4.77*x2 <= 108)
model.addConstr(11.23*x3 <= 108)
model.addConstr(4.77*x2 + 11.23*x3 >= 34)
model.addConstr(9.26*x1 + 11.23*x3 >= 29)
model.addConstr(9.26*x1 + 4.77*x2 + 11.23*x3 >= 29)
model.addConstr(-4*x2 + 8*x3 >= 0)
model.addConstr(9.26*x1 + 4.77*x2 <= 43)

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
    print(f"Hours worked by Laura: {x3.x}")
else:
    print("No optimal solution found.")
