
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="hours_worked_by_Mary", lb=0)
    x2 = model.addVar(name="hours_worked_by_Dale", lb=0)
    x3 = model.addVar(name="hours_worked_by_Laura", lb=0)

    # Objective function
    model.setObjective(8.72 * x1 + 5.55 * x2 + 1.19 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.77 * x2 + 11.23 * x3 >= 34)
    model.addConstr(9.26 * x1 + 11.23 * x3 >= 29)
    model.addConstr(9.26 * x1 + 4.77 * x2 + 11.23 * x3 >= 29)
    model.addConstr(-4 * x2 + 8 * x3 >= 0)
    model.addConstr(9.26 * x1 + 4.77 * x2 <= 43)
    model.addConstr(x1 <= 11.66)
    model.addConstr(x2 <= 22.64)
    model.addConstr(x3 <= 9.62)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Dale: {x2.varValue}")
        print(f"Hours worked by Laura: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
