
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
honeypots = m.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
mbps_bandwidth = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps_bandwidth")
system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")


# Set objective function
m.setObjective(7*honeypots + 6*security_engineers + 7*patches_per_day + mbps_bandwidth + 9*system_administrators + 6*security_onions + 9*deployed_decoys, gp.GRB.MINIMIZE)

# Add constraints
resources = {'r0': {'description': 'dollar cost', 'upper_bound': 1179, 'x0': 12, 'x1': 12, 'x2': 21, 'x3': 10, 'x4': 7, 'x5': 4, 'x6': 23}, 'r1': {'description': 'network latency impact', 'upper_bound': 1006, 'x0': 29, 'x1': 7, 'x2': 12, 'x3': 5, 'x4': 16, 'x5': 14, 'x6': 8}, 'r2': {'description': 'data confidentiality impact', 'upper_bound': 1173, 'x0': 22, 'x1': 20, 'x2': 11, 'x3': 26, 'x4': 8, 'x5': 27, 'x6': 24}, 'r3': {'description': 'computational load', 'upper_bound': 877, 'x0': 28, 'x1': 17, 'x2': 11, 'x3': 15, 'x4': 18, 'x5': 2, 'x6': 14}}
vars = [honeypots, security_engineers, patches_per_day, mbps_bandwidth, system_administrators, security_onions, deployed_decoys]

for r_key, r_data in resources.items():
    m.addConstr(sum(r_data[f'x{i}'] * vars[i] for i in range(len(vars))) <= r_data['upper_bound'], r_key)


m.addConstr(21*patches_per_day + 23*deployed_decoys >= 89)
m.addConstr(12*security_engineers + 23*deployed_decoys >= 155)
m.addConstr(7*system_administrators + 4*security_onions >= 144)
m.addConstr(10*mbps_bandwidth + 4*security_onions >= 161)
m.addConstr(10*mbps_bandwidth + 23*deployed_decoys >= 114)
m.addConstr(12*security_engineers + 10*mbps_bandwidth >= 87)
m.addConstr(21*patches_per_day + 4*security_onions >= 155)
m.addConstr(12*honeypots + 4*security_onions >= 114)
m.addConstr(21*patches_per_day + 10*mbps_bandwidth >= 75)
m.addConstr(4*security_onions + 23*deployed_decoys >= 114)
m.addConstr(7*system_administrators + 4*security_onions + 23*deployed_decoys >= 124)
m.addConstr(12*security_engineers + 21*patches_per_day + 10*mbps_bandwidth >= 124)
m.addConstr(12*honeypots + 7*system_administrators + 23*deployed_decoys >= 124)
m.addConstr(12*honeypots + 21*patches_per_day + 23*deployed_decoys >= 124)
m.addConstr(12*security_engineers + 21*patches_per_day + 23*deployed_decoys >= 124)
m.addConstr(21*patches_per_day + 10*mbps_bandwidth + 23*deployed_decoys >= 124)
m.addConstr(12*security_engineers + 7*system_administrators + 23*deployed_decoys >= 124)
m.addConstr(12*honeypots + 10*mbps_bandwidth + 7*system_administrators >= 124)
m.addConstr(12*honeypots + 12*security_engineers + 7*system_administrators >= 124)
m.addConstr(12*honeypots + 12*security_engineers + 10*mbps_bandwidth >= 124)
m.addConstr(12*security_engineers + 21*patches_per_day + 4*security_onions >= 124)
m.addConstr(21*patches_per_day + 7*system_administrators + 23*deployed_decoys >= 124)
m.addConstr(21*patches_per_day + 4*security_onions + 23*deployed_decoys >= 124)
m.addConstr(10*mbps_bandwidth + 7*system_administrators + 4*security_onions >= 124)
m.addConstr(12*honeypots + 21*patches_per_day + 4*security_onions >= 124)
m.addConstr(12*honeypots + 12*security_engineers + 4*security_onions >= 124)
m.addConstr(12*honeypots + 10*mbps_bandwidth + 23*deployed_decoys >= 124)
m.addConstr(12*honeypots + 4*security_onions + 23*deployed_decoys >= 124)
m.addConstr(12*honeypots + 12*security_engineers + 23*deployed_decoys >= 124)
m.addConstr(12*security_engineers + 10*mbps_bandwidth + 4*security_onions >= 124)
m.addConstr(12*honeypots + 21*patches_per_day + 7*system_administrators >= 124)
m.addConstr(12*security_engineers + 10*mbps_bandwidth + 7*system_administrators >= 124)
m.addConstr(12*security_engineers + 10*mbps_bandwidth + 23*deployed_decoys >= 124)


# ... (rest of the constraints, following the same pattern)

m.addConstr(6*patches_per_day - mbps_bandwidth >= 0)
m.addConstr(-4*mbps_bandwidth + 4*security_onions >= 0)
m.addConstr(12*security_engineers + 7*system_administrators <= 881)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

