
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x = m.addVars(5, vtype=gp.GRB.INTEGER, name=["network_administrators", "pen_testers", "security_engineers", "automatic_alerts", "patches_per_day"])


    # Set objective function
    m.setObjective(7.98*x[0] + 1.19*x[1] + 3.31*x[2] + 9.04*x[3] + 2.83*x[4], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x[0] + 4*x[1] + 15*x[2] + 10*x[3] + 9*x[4] <= 167, "available_bandwidth_impact")
    m.addConstr(15*x[0] + 5*x[1] + 2*x[2] + 5*x[3] + 2*x[4] <= 256, "network_integrity_impact")
    m.addConstr(15*x[0] + 5*x[1] + 5*x[3] >= 41, "network_integrity_constraint1")
    m.addConstr(15*x[0] + 2*x[2] + 2*x[4] >= 41, "network_integrity_constraint2")
    m.addConstr(15*x[0] + 5*x[1] + 2*x[4] >= 41, "network_integrity_constraint3")
    m.addConstr(15*x[0] + 5*x[1] + 5*x[3] >= 36, "network_integrity_constraint4")
    m.addConstr(15*x[0] + 2*x[2] + 2*x[4] >= 36, "network_integrity_constraint5")
    m.addConstr(15*x[0] + 5*x[1] + 2*x[4] >= 36, "network_integrity_constraint6")
    m.addConstr(15*x[0] + 5*x[1] + 5*x[3] >= 48, "network_integrity_constraint7")
    m.addConstr(15*x[0] + 2*x[2] + 2*x[4] >= 48, "network_integrity_constraint8")
    m.addConstr(15*x[0] + 5*x[1] + 2*x[4] >= 48, "network_integrity_constraint9")
    m.addConstr(15*x[2] + 9*x[4] <= 160, "bandwidth_constraint1")
    m.addConstr(6*x[0] + 9*x[4] <= 89, "bandwidth_constraint2")
    m.addConstr(6*x[0] + 15*x[2] <= 167, "bandwidth_constraint3")
    m.addConstr(4*x[1] + 9*x[4] <= 54, "bandwidth_constraint4")
    m.addConstr(6*x[0] + 10*x[3] <= 133, "bandwidth_constraint5")
    m.addConstr(4*x[1] + 15*x[2] + 10*x[3] <= 72, "bandwidth_constraint6")
    m.addConstr(6*x[0] + 4*x[1] + 15*x[2] + 10*x[3] + 9*x[4] <= 72, "bandwidth_constraint7")
    m.addConstr(15*x[0] + 2*x[2] <= 154, "network_integrity_constraint10")
    m.addConstr(15*x[0] + 2*x[4] <= 168, "network_integrity_constraint11")
    m.addConstr(5*x[1] + 5*x[3] + 2*x[4] <= 234, "network_integrity_constraint12")
    m.addConstr(15*x[0] + 5*x[1] + 2*x[2] + 5*x[3] + 2*x[4] <= 234, "network_integrity_constraint13")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
