
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # network administrators
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # pen testers
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # security engineers
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # automatic alerts
    x4 = model.addVar(name="x4", vtype=gurobi.GRB.INTEGER)  # patches per day

    # Objective function
    model.setObjective(7.98 * x0 + 1.19 * x1 + 3.31 * x2 + 9.04 * x3 + 2.83 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 4 * x1 + 15 * x2 + 10 * x3 + 9 * x4 <= 167)
    model.addConstr(15 * x0 + 5 * x1 + 2 * x2 + 5 * x3 + 2 * x4 <= 256)
    model.addConstr(15 * x0 + 5 * x1 + 5 * x3 >= 41)
    model.addConstr(15 * x0 + 2 * x2 + 2 * x4 >= 41)
    model.addConstr(15 * x0 + 5 * x1 + 2 * x4 >= 41)
    model.addConstr(15 * x0 + 5 * x1 + 5 * x3 >= 36)
    model.addConstr(15 * x0 + 2 * x2 + 2 * x4 >= 36)
    model.addConstr(15 * x0 + 5 * x1 + 2 * x4 >= 36)
    model.addConstr(15 * x0 + 5 * x1 + 5 * x3 >= 48)
    model.addConstr(15 * x0 + 2 * x2 + 2 * x4 >= 48)
    model.addConstr(15 * x0 + 5 * x1 + 2 * x4 >= 48)
    model.addConstr(15 * x2 + 9 * x4 <= 160)
    model.addConstr(6 * x0 + 9 * x4 <= 89)
    model.addConstr(6 * x0 + 15 * x2 <= 167)
    model.addConstr(4 * x1 + 9 * x4 <= 54)
    model.addConstr(6 * x0 + 10 * x3 <= 133)
    model.addConstr(4 * x1 + 15 * x2 + 10 * x3 <= 72)
    model.addConstr(6 * x0 + 4 * x1 + 15 * x2 + 10 * x3 + 9 * x4 <= 72)
    model.addConstr(15 * x0 + 2 * x2 <= 154)
    model.addConstr(15 * x0 + 2 * x4 <= 168)
    model.addConstr(5 * x1 + 5 * x3 + 2 * x4 <= 234)
    model.addConstr(15 * x0 + 5 * x1 + 2 * x2 + 5 * x3 + 2 * x4 <= 234)

    # Non-negativity constraints
    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("network administrators: ", x0.varValue)
        print("pen testers: ", x1.varValue)
        print("security engineers: ", x2.varValue)
        print("automatic alerts: ", x3.varValue)
        print("patches per day: ", x4.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
