
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
laura_hours = m.addVar(name="laura_hours")
ringo_hours = m.addVar(name="ringo_hours")

# Set objective function
m.setObjective(6.49 * laura_hours + 9.41 * ringo_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * laura_hours + 4 * ringo_hours >= 36, "paperwork_min")
m.addConstr(11 * laura_hours + 7 * ringo_hours >= 44, "organization_min")
m.addConstr(7 * laura_hours + 2 * ringo_hours >= 28, "productivity_min")
m.addConstr(10 * laura_hours - 5 * ringo_hours >= 0, "laura_ringo_relation")
m.addConstr(8 * laura_hours + 4 * ringo_hours <= 60, "paperwork_max")
m.addConstr(11 * laura_hours + 7 * ringo_hours <= 100, "organization_max")
m.addConstr(7 * laura_hours + 2 * ringo_hours <= 54, "productivity_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Laura hours: {laura_hours.x}')
    print(f'Ringo hours: {ringo_hours.x}')
    print(f'Objective value: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status {m.status}')

