
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Laura
x2 = m.addVar(name="hours_worked_by_Ringo", lb=0)  # Ringo

# Objective function
m.setObjective(6.49*x1 + 9.41*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(8*x1 + 4*x2 >= 36, name="paperwork_competence")
m.addConstr(11*x1 + 7*x2 >= 44, name="organization_score")
m.addConstr(7*x1 + 2*x2 >= 28, name="productivity_rating")
m.addConstr(10*x1 - 5*x2 >= 0, name="combined_rating_constraint")
m.addConstr(8*x1 + 4*x2 <= 60, name="paperwork_competence_upper_bound")
m.addConstr(11*x1 + 7*x2 <= 100, name="organization_score_upper_bound")
m.addConstr(7*x1 + 2*x2 <= 54, name="productivity_rating_upper_bound")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Hours worked by Ringo: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
