
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b4 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b4")
iron = m.addVar(vtype=gp.GRB.INTEGER, name="iron")
protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
magnesium = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")
fiber = m.addVar(vtype=gp.GRB.INTEGER, name="fiber")


# Set objective function
m.setObjective(1 * vitamin_b4 + 5 * iron + 6 * protein + 6 * magnesium + 1 * fiber, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.98 * vitamin_b4 + 4.92 * iron <= 201, "r0")
m.addConstr(1.66 * vitamin_b4 + 2.27 * iron <= 115, "r1")
# ... (add all other constraints similarly based on the JSON representation)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value: %g' % m.objVal)
    print('vitamin_b4:', vitamin_b4.x)
    print('iron:', iron.x)
    print('protein:', protein.x)
    print('magnesium:', magnesium.x)
    print('fiber:', fiber.x)

elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

