
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    apple_pies = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
    lemons = m.addVar(vtype=GRB.INTEGER, name="lemons")
    bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

    # Set objective function
    m.setObjective(7.06*apple_pies*lemons + 9.79*lemons**2 + 8.75*lemons*bowls_of_cereal + 8.31*bowls_of_cereal, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12.53*apple_pies + 10.8*lemons + 12.65*bowls_of_cereal <= 143, "c0")
    m.addConstr(7.39*apple_pies + 12.51*lemons + 5.63*bowls_of_cereal <= 198, "c1")
    m.addConstr(7.25*apple_pies + 0.15*lemons + 3.3*bowls_of_cereal <= 127, "c2")
    m.addConstr(12.53*apple_pies**2 + 12.65*bowls_of_cereal**2 >= 38, "c3")
    m.addConstr(12.53*apple_pies**2 + 10.8*lemons**2 + 12.65*bowls_of_cereal**2 >= 28, "c4")
    m.addConstr(12.53*apple_pies + 10.8*lemons + 12.65*bowls_of_cereal >= 28, "c5")
    m.addConstr(7.39*apple_pies + 5.63*bowls_of_cereal >= 42, "c6")
    m.addConstr(12.51*lemons + 5.63*bowls_of_cereal >= 32, "c7")
    m.addConstr(7.39*apple_pies + 12.51*lemons + 5.63*bowls_of_cereal >= 32, "c8")
    m.addConstr(7.25*apple_pies + 3.3*bowls_of_cereal >= 23, "c9")
    m.addConstr(0.15*lemons**2 + 3.3*bowls_of_cereal**2 >= 36, "c10")
    m.addConstr(7.25*apple_pies + 0.15*lemons + 3.3*bowls_of_cereal >= 39, "c11")
    m.addConstr(12.53*apple_pies**2 + 12.65*bowls_of_cereal**2 <= 114, "c12")
    m.addConstr(10.8*lemons + 12.65*bowls_of_cereal <= 114, "c13")
    m.addConstr(0.15*lemons + 3.3*bowls_of_cereal <= 112, "c14")
    m.addConstr(7.25*apple_pies**2 + 3.3*bowls_of_cereal**2 <= 79, "c15")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
