
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='apple_pies', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='lemons', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='bowls_of_cereal', vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(7.06 * x1 * x2 + 9.79 * x2**2 + 8.75 * x2 * x3 + 8.31 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(12.53 * x1 + 10.8 * x2 + 12.65 * x3 <= 143)
m.addConstr(7.39 * x1 + 12.51 * x2 + 5.63 * x3 <= 198)
m.addConstr(7.25 * x1 + 0.15 * x2 + 3.3 * x3 <= 127)
m.addConstr(12.53 * x1**2 + 12.65 * x3**2 >= 38)
m.addConstr(12.53 * x1**2 + 10.8 * x2**2 + 12.65 * x3**2 >= 28)
m.addConstr(12.53 * x1 + 10.8 * x2 + 12.65 * x3 >= 28)
m.addConstr(7.39 * x1 + 5.63 * x3 >= 42)
m.addConstr(12.51 * x2 + 5.63 * x3 >= 32)
m.addConstr(7.39 * x1 + 12.51 * x2 + 5.63 * x3 >= 32)
m.addConstr(7.25 * x1 + 3.3 * x3 >= 23)
m.addConstr(0.15 * x2**2 + 3.3 * x3**2 >= 36)
m.addConstr(7.25 * x1 + 0.15 * x2 + 3.3 * x3 >= 39)
m.addConstr(7.25 * x1 + 0.15 * x2 + 3.3 * x3 >= 39)
m.addConstr(12.53 * x1**2 + 12.65 * x3**2 <= 114)
m.addConstr(10.8 * x2 + 12.65 * x3 <= 114)
m.addConstr(0.15 * x2 + 3.3 * x3 <= 112)
m.addConstr(7.25 * x1**2 + 3.3 * x3**2 <= 79)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Apple pies: ', x1.varValue)
    print('Lemons: ', x2.varValue)
    print('Bowls of cereal: ', x3.varValue)
else:
    print('The model is infeasible')
