
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry_companies")


    # Set objective function
    m.setObjective(4*x0 + 4*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 12*x1 >= 78, "fuel_demand_min")
    m.addConstr(5*x0 + 9*x1 >= 41, "fun_factor_min")
    m.addConstr(13*x0 + 2*x1 >= 33, "mobility_rating_min")
    m.addConstr(17*x0 + 8*x1 >= 17, "deployment_weight_min")
    m.addConstr(12*x0 + 14*x1 >= 17, "logistics_footprint_min")
    m.addConstr(-1*x0 + 9*x1 >= 0, "custom_constraint_1")
    m.addConstr(4*x0 + 12*x1 <= 112, "fuel_demand_max")
    m.addConstr(5*x0 + 9*x1 <= 126, "fun_factor_max")
    m.addConstr(13*x0 + 2*x1 <= 62, "mobility_rating_max")
    m.addConstr(17*x0 + 8*x1 <= 48, "deployment_weight_max")
    m.addConstr(12*x0 + 14*x1 <= 25, "logistics_footprint_max")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('signal_platoons:', x0.x)
        print('light_infantry_companies:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
