
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
x1 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")

# Set the objective function
m.setObjective(4*x0 + 4*x1, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(4*x0 + 12*x1 >= 78, "fuel_demand_min")
m.addConstr(4*x0 + 12*x1 <= 112, "fuel_demand_max")
m.addConstr(5*x0 + 9*x1 >= 41, "fun_factor_min")
m.addConstr(5*x0 + 9*x1 <= 126, "fun_factor_max")
m.addConstr(13*x0 + 2*x1 >= 33, "mobility_rating_min")
m.addConstr(13*x0 + 2*x1 <= 62, "mobility_rating_max")
m.addConstr(17*x0 + 8*x1 >= 17, "deployment_weight_min")
m.addConstr(17*x0 + 8*x1 <= 48, "deployment_weight_max")
m.addConstr(12*x0 + 14*x1 >= 17, "logistics_footprint_min")
m.addConstr(12*x0 + 14*x1 <= 25, "logistics_footprint_max")
m.addConstr(-x0 + 9*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Signal platoons: {x0.x}")
    print(f"Light infantry companies: {x1.x}")
else:
    print("No optimal solution found")
