
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="signal_platoons", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(4 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4 * x1 + 12 * x2 >= 78, name="fuel_demand_constraint")
    model.addConstr(5 * x1 + 9 * x2 >= 41, name="fun_factor_constraint")
    model.addConstr(13 * x1 + 2 * x2 >= 33, name="mobility_rating_constraint")
    model.addConstr(17 * x1 + 8 * x2 >= 17, name="deployment_weight_constraint")
    model.addConstr(12 * x1 + 14 * x2 >= 17, name="logistics_footprint_constraint")
    model.addConstr(-x1 + 9 * x2 >= 0, name="light_infantry_fun_factor_constraint")
    model.addConstr(4 * x1 + 12 * x2 <= 112, name="fuel_demand_upper_bound_constraint")
    model.addConstr(5 * x1 + 9 * x2 <= 126, name="fun_factor_upper_bound_constraint")
    model.addConstr(13 * x1 + 2 * x2 <= 62, name="mobility_rating_upper_bound_constraint")
    model.addConstr(17 * x1 + 8 * x2 <= 48, name="deployment_weight_upper_bound_constraint")
    model.addConstr(12 * x1 + 14 * x2 <= 25, name="logistics_footprint_upper_bound_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Signal platoons: {x1.varValue}")
        print(f"Light infantry companies: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
