
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("likelihood_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_jean")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_laura")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_mary")


    # Set objective function
    m.setObjective(6*x0 + 2*x1 + 8*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(1.81*x0 + 2.04*x1 >= 141, "c1")
    m.addConstr(2.04*x1 + 2.11*x2 <= 327, "c2")
    m.addConstr(1.81*x0 + 2.04*x1 <= 321, "c3")
    m.addConstr(1.81*x0 + 2.04*x1 + 2.11*x2 <= 321, "c4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

