
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Jean")
x2 = m.addVar(lb=0, name="hours_worked_by_Laura")
x3 = m.addVar(lb=0, name="hours_worked_by_Mary")

# Set the objective function
m.setObjective(6*x1 + 2*x2 + 8*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.81*x1 + 2.04*x2 >= 141, "Minimum_combined_likelihood_Jean_Laura")
m.addConstr(2.04*x2 + 2.11*x3 <= 327, "Maximum_combined_likelihood_Laura_Mary")
m.addConstr(1.81*x1 + 2.04*x2 <= 321, "Maximum_combined_likelihood_Jean_Laura")
m.addConstr(1.81*x1 + 2.04*x2 + 2.11*x3 <= 321, "Maximum_total_combined_likelihood")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {x1.x}")
    print(f"Hours worked by Laura: {x2.x}")
    print(f"Hours worked by Mary: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
