
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Jean', lb=0, ub=269.06)
    x2 = model.addVar(name='hours_worked_by_Laura', lb=0, ub=238.73)
    x3 = model.addVar(name='hours_worked_by_Mary', lb=0, ub=230.81)

    # Define the objective function
    model.setObjective(6 * x1 + 2 * x2 + 8 * x3, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(1.81 * x1 + 2.04 * x2 >= 141)
    model.addConstr(2.04 * x2 + 2.11 * x3 <= 327)
    model.addConstr(1.81 * x1 + 2.04 * x2 <= 321)
    model.addConstr(1.81 * x1 + 2.04 * x2 + 2.11 * x3 <= 321)

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print('Optimal solution found.')
        print('Hours worked by Jean: ', x1.varValue)
        print('Hours worked by Laura: ', x2.varValue)
        print('Hours worked by Mary: ', x3.varValue)
        print('Objective function value: ', model.objVal)
    else:
        print('No optimal solution found.')

solve_optimization_problem()
