
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_optimization")

    # Create variables
    intrusion_analysts = model.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
    honeypots = model.addVar(vtype=gp.GRB.INTEGER, name="honeypots")


    # Set objective function
    model.setObjective(6.44 * intrusion_analysts + 9.58 * honeypots, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5 * intrusion_analysts + 18 * honeypots >= 40, "power_consumption_min")
    model.addConstr(4 * intrusion_analysts + 8 * honeypots >= 13, "computational_load_min")
    model.addConstr(6 * intrusion_analysts - 4 * honeypots >= 0, "analyst_honeypot_ratio")
    model.addConstr(5 * intrusion_analysts + 18 * honeypots <= 86, "power_consumption_max")
    model.addConstr(4 * intrusion_analysts + 8 * honeypots <= 59, "computational_load_max")



    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('intrusion_analysts:', intrusion_analysts.x)
        print('honeypots:', honeypots.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
