
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x2 = m.addVar(vtype=GRB.INTEGER, name="honeypots")

# Set the objective function
m.setObjective(6.44*x1 + 9.58*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 18*x2 >= 40, "power_consumption_min")
m.addConstr(5*x1 + 18*x2 <= 86, "power_consumption_max")
m.addConstr(4*x1 + 8*x2 >= 13, "computational_load_min")
m.addConstr(4*x1 + 8*x2 <= 59, "computational_load_max")
m.addConstr(6*x1 - 4*x2 >= 0, "analysts_honeypots_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Intrusion Analysts: {x1.x}")
    print(f"Honeypots: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
