
import gurobipy as gp

# Create a new model
m = gp.Model("intrusion_analysts_honeypots")

# Define variables
x1 = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)  # Intrusion analysts
x2 = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)  # Honeypots

# Objective function: Minimize 6.44 * x1 + 9.58 * x2
m.setObjective(6.44 * x1 + 9.58 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5 * x1 + 18 * x2 >= 40, name="power_min")  # Power consumption minimum
m.addConstr(4 * x1 + 8 * x2 >= 13, name="computational_load_min")  # Computational load minimum
m.addConstr(6 * x1 - 4 * x2 >= 0, name="balance")  # Intrusion analysts vs Honeypots balance
m.addConstr(5 * x1 + 18 * x2 <= 86, name="power_max")  # Power consumption maximum
m.addConstr(4 * x1 + 8 * x2 <= 59, name="computational_load_max")  # Computational load maximum

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Intrusion Analysts: {x1.varValue}")
    print(f"Honeypots: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
