
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="cornichons", lb=0)
x1 = m.addVar(name="apple_pies", lb=0)
x2 = m.addVar(name="strips_of_bacon", lb=0)
x3 = m.addVar(name="cheeseburgers", lb=0)

# Set the objective function
m.setObjective(2.18*x0 + 4.04*x1 + 4.38*x2 + 6.25*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 25*x1 + 26*x2 + 11*x3 <= 692)
m.addConstr(21*x0 + 32*x1 + 13*x2 + 4*x3 <= 239)
m.addConstr(25*x1 + 11*x3 >= 102)
m.addConstr(5*x0 + 11*x3 >= 136)
m.addConstr(5*x0 + 26*x2 >= 98)
m.addConstr(25*x1 + 26*x2 >= 102)
m.addConstr(5*x0 + 26*x2 + 11*x3 >= 121)
m.addConstr(32*x1 + 4*x3 >= 59)
m.addConstr(13*x2 + 4*x3 >= 46)
m.addConstr(21*x0 + 32*x1 >= 46)
m.addConstr(21*x0 + 4*x3 >= 50)
m.addConstr(21*x0 + 13*x2 + 4*x3 >= 41)
m.addConstr(6*x2 - 9*x3 >= 0)
m.addConstr(5*x0 + 11*x3 <= 403)
m.addConstr(25*x1 + 26*x2 <= 553)
m.addConstr(5*x0 + 25*x1 <= 377)
m.addConstr(25*x1 + 11*x3 <= 459)
m.addConstr(26*x2 + 11*x3 <= 358)
m.addConstr(25*x1 + 26*x2 + 11*x3 <= 537)
m.addConstr(5*x0 + 25*x1 + 26*x2 + 11*x3 <= 537)
m.addConstr(21*x0 + 32*x1 <= 182)
m.addConstr(13*x2 + 4*x3 <= 218)
m.addConstr(21*x0 + 32*x1 + 13*x2 + 4*x3 <= 218)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("cornichons: ", x0.x)
    print("apple_pies: ", x1.x)
    print("strips_of_bacon: ", x2.x)
    print("cheeseburgers: ", x3.x)
else:
    print("The model is infeasible")
