
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b6")

    # Set objective function
    m.setObjective(5.28 * magnesium + 4.71 * vitamin_b2 + 8.96 * vitamin_c + 6.81 * vitamin_b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4.9 * magnesium + 4.7 * vitamin_c >= 37)
    m.addConstr(4.36 * vitamin_b2 + 4.7 * vitamin_c >= 26)
    m.addConstr(3.03 * vitamin_b2 + 4.5 * vitamin_c >= 36)
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 <= 101)
    m.addConstr(4.9 * magnesium + 5.86 * vitamin_b6 <= 96)
    m.addConstr(4.7 * vitamin_c + 5.86 * vitamin_b6 <= 69)
    m.addConstr(4.36 * vitamin_b2 + 5.86 * vitamin_b6 <= 141)
    m.addConstr(4.9 * magnesium + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 185)
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 + 5.86 * vitamin_b6 <= 100)
    m.addConstr(4.36 * vitamin_b2 + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 157)
    m.addConstr(4.9 * magnesium + 4.36 * vitamin_b2 + 4.7 * vitamin_c + 5.86 * vitamin_b6 <= 157)
    m.addConstr(5.9 * magnesium + 1.5 * vitamin_b6 <= 71)
    m.addConstr(4.5 * vitamin_c + 1.5 * vitamin_b6 <= 71)
    m.addConstr(3.03 * vitamin_b2 + 1.5 * vitamin_b6 <= 186)
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 <= 188)
    m.addConstr(3.03 * vitamin_b2 + 4.5 * vitamin_c <= 87)
    m.addConstr(5.9 * magnesium + 4.5 * vitamin_c <= 164)
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 1.5 * vitamin_b6 <= 157)
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 4.5 * vitamin_c <= 150)
    m.addConstr(5.9 * magnesium + 3.03 * vitamin_b2 + 4.5 * vitamin_c + 1.5 * vitamin_b6 <= 150)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
