
import gurobi as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # milligrams of magnesium
x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B2
x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin C
x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin B6

# Define the objective function
model.setObjective(5.28*x0 + 4.71*x1 + 8.96*x2 + 6.81*x3, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4.9*x0 <= 235)
model.addConstr(5.9*x0 <= 196)
model.addConstr(4.36*x1 <= 235)
model.addConstr(3.03*x1 <= 196)
model.addConstr(4.7*x2 <= 235)
model.addConstr(4.5*x2 <= 196)
model.addConstr(5.86*x3 <= 235)
model.addConstr(1.5*x3 <= 196)

model.addConstr(4.9*x0 + 4.7*x2 >= 37)
model.addConstr(4.36*x1 + 4.7*x2 >= 26)
model.addConstr(3.03*x1 + 4.5*x2 >= 36)

model.addConstr(4.9*x0 + 4.36*x1 <= 101)
model.addConstr(4.9*x0 + 5.86*x3 <= 96)
model.addConstr(4.7*x2 + 5.86*x3 <= 69)
model.addConstr(4.36*x1 + 5.86*x3 <= 141)
model.addConstr(4.9*x0 + 4.7*x2 + 5.86*x3 <= 185)
model.addConstr(4.9*x0 + 4.36*x1 + 5.86*x3 <= 100)
model.addConstr(4.36*x1 + 4.7*x2 + 5.86*x3 <= 157)
model.addConstr(4.9*x0 + 4.36*x1 + 4.7*x2 + 5.86*x3 <= 157)

model.addConstr(5.9*x0 + 1.5*x3 <= 71)
model.addConstr(4.5*x2 + 1.5*x3 <= 71)
model.addConstr(3.03*x1 + 1.5*x3 <= 186)
model.addConstr(5.9*x0 + 3.03*x1 <= 188)
model.addConstr(3.03*x1 + 4.5*x2 <= 87)
model.addConstr(5.9*x0 + 4.5*x2 <= 164)
model.addConstr(5.9*x0 + 3.03*x1 + 1.5*x3 <= 157)
model.addConstr(5.9*x0 + 3.03*x1 + 4.5*x2 <= 150)
model.addConstr(5.9*x0 + 3.03*x1 + 4.5*x2 + 1.5*x3 <= 150)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
