
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")


    # Set objective function
    m.setObjective(6*x0 + 1*x1 + 1*x2 + 2*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 6*x1 >= 21)
    m.addConstr(7*x0 + 3*x3 >= 29)
    m.addConstr(6*x1 + 13*x2 >= 15)
    m.addConstr(7*x0 + 6*x1 + 13*x2 >= 30)
    m.addConstr(6*x1 + 13*x2 + 3*x3 >= 30)
    m.addConstr(7*x0 + 13*x2 + 3*x3 >= 30)
    m.addConstr(7*x0 + 6*x1 + 13*x2 >= 16)
    m.addConstr(6*x1 + 13*x2 + 3*x3 >= 16)
    m.addConstr(7*x0 + 13*x2 + 3*x3 >= 16)
    m.addConstr(7*x0 + 6*x1 + 13*x2 >= 33)
    m.addConstr(6*x1 + 13*x2 + 3*x3 >= 33)
    m.addConstr(7*x0 + 13*x2 + 3*x3 >= 33)
    m.addConstr(7*x0 + 6*x1 + 13*x2 + 3*x3 >= 33)
    m.addConstr(10*x0 + 20*x2 >= 44)
    m.addConstr(9*x1 + 20*x2 >= 44)
    m.addConstr(10*x0 + 9*x1 + 12*x3 >= 69)
    m.addConstr(10*x0 + 9*x1 + 20*x2 + 12*x3 >= 69)
    m.addConstr(6*x2 + 12*x3 >= 41)
    m.addConstr(26*x1 + 12*x3 >= 91)
    m.addConstr(4*x0 + 6*x2 >= 39)
    m.addConstr(4*x0 + 26*x1 + 6*x2 + 12*x3 >= 39)
    m.addConstr(3*x0 + 19*x2 >= 102)
    m.addConstr(3*x0 + 15*x1 + 19*x2 + 3*x3 >= 102)
    m.addConstr(-4*x0 + 6*x2 >= 0)
    m.addConstr(-8*x1 + 6*x3 >= 0)
    m.addConstr(6*x1 + 13*x2 + 3*x3 <= 87)
    m.addConstr(4*x0 + 26*x1 + 6*x2 <= 154)
    m.addConstr(19*x2 + 3*x3 <= 421)
    m.addConstr(3*x0 + 15*x1 <= 347)
    m.addConstr(3*x0 + 15*x1 + 19*x2 <= 285)

    # Resource Constraints
    m.addConstr(7*x0 + 6*x1 + 13*x2 + 3*x3 <= 134)
    m.addConstr(10*x0 + 9*x1 + 20*x2 + 12*x3 <= 321)
    m.addConstr(4*x0 + 26*x1 + 6*x2 + 12*x3 <= 402)
    m.addConstr(3*x0 + 15*x1 + 19*x2 + 3*x3 <= 451)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
