
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams of vitamin B1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="grams of fat", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = model.addVar(name="grams of carbohydrates", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = model.addVar(name="grams of protein", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(6 * x1 + x2 + x3 + 2 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * x1 <= 134)
model.addConstr(10 * x1 <= 321)
model.addConstr(4 * x1 <= 402)
model.addConstr(3 * x1 <= 451)

model.addConstr(6 * x2 <= 134)
model.addConstr(9 * x2 <= 321)
model.addConstr(26 * x2 <= 402)
model.addConstr(15 * x2 <= 451)

model.addConstr(13 * x3 <= 134)
model.addConstr(20 * x3 <= 321)
model.addConstr(6 * x3 <= 402)
model.addConstr(19 * x3 <= 451)

model.addConstr(3 * x4 <= 134)
model.addConstr(12 * x4 <= 321)
model.addConstr(12 * x4 <= 402)
model.addConstr(3 * x4 <= 451)

model.addConstr(7 * x1 + 6 * x2 >= 21)
model.addConstr(7 * x1 + 3 * x4 >= 29)
model.addConstr(6 * x2 + 13 * x3 >= 15)
model.addConstr(7 * x1 + 6 * x2 + 13 * x3 >= 30)
model.addConstr(6 * x2 + 13 * x3 + 3 * x4 >= 30)
model.addConstr(7 * x1 + 13 * x3 + 3 * x4 >= 30)
model.addConstr(7 * x1 + 6 * x2 + 13 * x3 >= 16)
model.addConstr(6 * x2 + 13 * x3 + 3 * x4 >= 16)
model.addConstr(7 * x1 + 13 * x3 + 3 * x4 >= 16)
model.addConstr(7 * x1 + 6 * x2 + 13 * x3 >= 33)
model.addConstr(6 * x2 + 13 * x3 + 3 * x4 >= 33)
model.addConstr(7 * x1 + 13 * x3 + 3 * x4 >= 33)
model.addConstr(7 * x1 + x2 + x3 + x4 >= 33)

model.addConstr(10 * x1 + 20 * x3 >= 44)
model.addConstr(9 * x2 + 20 * x3 >= 44)
model.addConstr(10 * x1 + 9 * x2 + 12 * x4 >= 69)
model.addConstr(10 * x1 + 9 * x2 + 20 * x3 + 12 * x4 >= 69)

model.addConstr(6 * x3 + 12 * x4 >= 41)
model.addConstr(26 * x2 + 12 * x4 >= 91)
model.addConstr(4 * x1 + 6 * x3 >= 39)
model.addConstr(4 * x1 + 26 * x2 + 6 * x3 + 12 * x4 >= 39)

model.addConstr(3 * x1 + 19 * x3 >= 102)
model.addConstr(3 * x1 + 15 * x2 + 19 * x3 + 3 * x4 >= 102)

model.addConstr(-4 * x1 + 6 * x3 >= 0)
model.addConstr(-8 * x2 + 6 * x4 >= 0)

model.addConstr(6 * x2 + 13 * x3 + 3 * x4 <= 87)
model.addConstr(4 * x1 + 26 * x2 + 6 * x3 <= 154)
model.addConstr(19 * x3 + 3 * x4 <= 421)
model.addConstr(3 * x1 + 15 * x2 <= 347)
model.addConstr(3 * x1 + 15 * x2 + 19 * x3 <= 285)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
else:
    print("The model is infeasible")
